/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

class ConfigSet {
    public Vector<ConfigEntry> ordered = new Vector();
    public Map<String, Integer> lookup = new HashMap<String, Integer>();
    public InputStream in = System.in;
    public PrintStream out = System.out;

    public ConfigSet() {
    }

    public ConfigSet(InputStream inputStream, PrintStream printStream) {
        this();
        this.in = inputStream;
        this.out = printStream;
    }

    public void add(ConfigEntry configEntry) {
        this.ordered.add(configEntry);
        this.lookup.put(configEntry.getName(), this.ordered.size() - 1);
    }

    public ConfigEntry get(String string) {
        return this.ordered.elementAt(this.lookup.get(string));
    }

    private void readEntry(BufferedReader bufferedReader, Twiddler twiddler) throws IOException {
        ConfigEntry configEntry;
        String string = ConfigEntry.readString(bufferedReader, "type");
        if (string.equals("string")) {
            configEntry = new ConfigEntryString();
        } else if (string.equals("choice")) {
            configEntry = new ConfigEntryChoice();
        } else if (string.equals("double")) {
            configEntry = new ConfigEntryDouble();
        } else if (string.equals("unsigned_long")) {
            configEntry = new ConfigEntryLong(true);
        } else if (string.equals("long")) {
            configEntry = new ConfigEntryLong();
        } else if (string.equals("bool")) {
            configEntry = new ConfigEntryBool();
        } else if (string.equals("trigger")) {
            configEntry = new ConfigEntryTrigger();
        } else if (string.equals("divider")) {
            configEntry = new ConfigEntryDivider();
        } else {
            System.err.println("Unexpected type \"" + string + "\"");
            System.exit(1);
            return;
        }
        configEntry.setOutput(this.out);
        configEntry.readDefinition(bufferedReader);
        configEntry.addToTwiddler(twiddler);
        this.add(configEntry);
    }

    public void inputDefinition(Twiddler twiddler) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.in));
            String string = bufferedReader.readLine();
            while (string.equals("pulse")) {
                string = bufferedReader.readLine();
            }
            int n = Integer.parseInt(string);
            System.err.println("numEntries = " + n);
            for (int i = 0; i < n; ++i) {
                this.readEntry(bufferedReader, twiddler);
            }
        }
        catch (IOException iOException) {
            System.err.println("exception " + iOException);
        }
    }

    public boolean inputSingleEntry(String[] stringArray, int n) {
        if (stringArray.length <= n) {
            System.err.println("Error reading config entry: expected name, but line ended prematurely");
            return false;
        }
        String string = stringArray[n];
        if (string.charAt(0) == '#') {
            return true;
        }
        if (stringArray.length <= n + 1) {
            System.err.println("Error reading config entry: expected '=', but line ended prematurely");
            return false;
        }
        if (!stringArray[n + 1].equals("=")) {
            System.err.println("Error reading config entry: expected '=', found \"" + stringArray[n + 1] + "\"");
            return false;
        }
        if (!this.lookup.containsKey(string)) {
            System.err.println("Error reading config entry: unknown parameter name \"" + string + "\"");
            return false;
        }
        ConfigEntry configEntry = this.ordered.elementAt(this.lookup.get(string));
        if (stringArray.length <= n + 2) {
            System.err.println("Error reading config entry: expected value for \"" + string + "\", but line ended prematurely");
            return false;
        }
        String string2 = stringArray[n + 2];
        if (!configEntry.setValueFromInputStream(string2)) {
            System.err.println("Error reading config entry: error setting value for parameter \"" + string + "\" to \"" + string2 + "\"");
            return false;
        }
        return true;
    }

    private void readUpdate(BufferedReader bufferedReader) throws IOException {
        String[] stringArray = ConfigEntry.readLineWords(bufferedReader, 4);
        if (stringArray.length >= 1 && stringArray[0].equals("set")) {
            this.inputSingleEntry(stringArray, 1);
        } else if (stringArray.length < 1 || !stringArray[0].equals("pulse")) {
            System.err.print("Unknown command: ");
            for (int i = 0; i < stringArray.length; ++i) {
                System.err.print("\"" + stringArray[i] + "\"");
                if (i >= stringArray.length - 1) continue;
                System.err.print(", ");
            }
            System.err.println();
        }
    }

    public void monitorInputForever() {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(this.in);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while (true) {
                this.readUpdate(bufferedReader);
            }
        }
        catch (IOException iOException) {
            System.err.println("exception " + iOException);
            return;
        }
    }
}

