/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;

class ConfigEntryDouble
extends ConfigEntryNumber {
    private double value = 0.0;
    private double increment = 0.0;
    private boolean hasmin;
    private double minvalue;
    private boolean hasmax;
    private double maxvalue;

    public ConfigEntryDouble() {
        this.setNoMin();
        this.setNoMax();
    }

    public boolean setValue(String string, boolean bl, boolean bl2) {
        try {
            this.setValue(Double.parseDouble(string), bl, bl2);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public void setValue(double d, boolean bl, boolean bl2) {
        if (this.hasmin && d < this.minvalue) {
            d = this.minvalue;
        }
        if (this.hasmax && d > this.maxvalue) {
            d = this.maxvalue;
        }
        if (this.value != d) {
            this.value = d;
            if (bl) {
                this.doPrint();
            }
        }
        if (bl2) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            printStream.format("%f", this.value);
            this.textField.setText(byteArrayOutputStream.toString());
        }
    }

    public boolean setValueFromInputStream(String string) {
        return this.setValue(string, false, true);
    }

    public void adjustValue(int n) {
        this.setValue(this.value - (double)n * this.increment, true, true);
    }

    public void setMin(double d) {
        this.hasmin = true;
        this.minvalue = d;
    }

    public void setNoMin() {
        this.hasmin = false;
    }

    public void setMax(double d) {
        this.hasmax = true;
        this.maxvalue = d;
    }

    public void setNoMax() {
        this.hasmax = false;
    }

    public void setIncrement(double d) {
        this.increment = d;
    }

    public void doSpecificPrint(PrintStream printStream) {
        printStream.format("%f", this.value);
    }

    public void readDefinitionSpecific(BufferedReader bufferedReader) throws IOException {
        this.setValue(ConfigEntryDouble.readDouble(bufferedReader, "value"), false, true);
        this.setIncrement(ConfigEntryDouble.readDouble(bufferedReader, "increment"));
        this.hasmin = ConfigEntryDouble.readBoolean(bufferedReader, "hasmin");
        if (this.hasmin) {
            this.setMin(ConfigEntryDouble.readDouble(bufferedReader, "min"));
        } else {
            this.setNoMin();
        }
        this.hasmax = ConfigEntryDouble.readBoolean(bufferedReader, "hasmax");
        if (this.hasmax) {
            this.setMax(ConfigEntryDouble.readDouble(bufferedReader, "max"));
        } else {
            this.setNoMax();
        }
    }
}

