
// SimParm: Simple and flexible C++ configuration framework
// Copyright (C) 2007 Australian National University
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// Contact:
// Kevin Pulo
// kevin.pulo@anu.edu.au
// Leonard Huxley Bldg 56
// Australian National University, ACT, 0200, Australia

//package simparm.twiddler;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;



public class Twiddler extends JPanel {

	public int numControls;
	public ConfigSet config;

	public Twiddler() {
		this(System.in, System.out);
	}

	public Twiddler(InputStream in, PrintStream out) {
		config = new ConfigSet(in, out);

		numControls = 0;

        setLayout(new GridLayout(1,2));

		config.inputDefinition(this);

		if (numControls == 0) {
			add(new Label("No controls added!"));
		}

        setLayout(new GridLayout(numControls,2));
	}

    public static void main(String args[]) throws IOException {
		Frame f = new Frame("Twiddler");
        f.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {System.exit(0);}
        });

		String pid_str = Long.toString(Thread.currentThread().getId());
		String fifo_fname_out = ".control-" + pid_str + ".in";
		String fifo_fname_in = ".control-" + pid_str + ".out";
		Process mkfifo = Runtime.getRuntime().exec("mkfifo " + fifo_fname_out + " " + fifo_fname_in);
		int rc = -1;
		while (rc < 0) {
			try {
				rc = mkfifo.waitFor();
			} catch (InterruptedException e) {
			}
		}
		if (rc != 0) {
			System.err.println("Error: unable to create control fifos");
			System.exit(rc);
		}

		//Twiddler twiddler = new Twiddler(System.in, System.out);

		System.err.print("Waiting to connect to " + fifo_fname_out + "... ");
		System.err.flush();
		PrintStream output = new PrintStream(new FileOutputStream(fifo_fname_out));
		System.err.println("connected");
		System.err.print("Waiting to connect to " + fifo_fname_in + "... ");
		System.err.flush();
		InputStream input = new FileInputStream(fifo_fname_in);
		System.err.println("done");
		Twiddler twiddler = new Twiddler(input, output);

		f.add("Center", twiddler);
		f.pack();
		f.setVisible(true);

		twiddler.config.monitorInputForever();
    }
}



